var express = require('express');
var app = express();
var GeoJSON = require('geojson');
var sqlite = require('spatialite');
var db = new sqlite.Database('data/CECIM');
//var cors = require('cors')
//app.use(cors())

//TEST OF FASTEST c
//"select *,AsGeoJSON(geom) from IRIS_DONNEES where IRIS_DONNEES.ROWID IN (select ROWID from SpatialIndex where f_table_name='IRIS_DONNEES' and search_frame=BuildMBR( 2,2 ,100 ,100 ));"
//app.use('/', express.static(__dirname + '/Public'));
app.use('/', function(req, res, next) {

	if(req.headers.referer === undefined) {
		// res.status(403);
		// req.url = '/403';
	}

	if(!/^https:\/\/www.cecimobs.net\/geoscop\/*/.test(req.headers.referer) && !/^https:\/\/cecim.agat-dev.fr*/.test(req.headers.referer) ) {
		// res.status(403);
		// req.url = '/403';
	}

	next();
})

app.use('/', express.static(__dirname + '/Public'));

app.use('/403', express.static(__dirname + '/403'));

app.get('/max', function (req, res) {
	var what = req.query.what;
	// if (what === "perchlm" && Bdd==='dept') {what = "%  HLM";}
	var Bdd = req.query.db;
	if (Bdd==='iris') var tablename = "IRIS_donnees_2021";
	if (Bdd==='dept') var tablename = "DEPARTEMENTS_donnees_2021";
	if (Bdd==='comm') var tablename = "COMMUNES_donnees_2021";

	var query = "select max(cast(replace(\""+what+"\",',','.') as float)) as max, min(cast(replace(\""+what+"\",',','.') as float)) as min from "+tablename+";"
	var resu;

	db.spatialite(function(err) {
	  db.each(query, function(err, row) {
	  	resu = row;
	  }, function() {
	  	res.json(resu);
	  })
	});
});


app.get('/coord', function (req, res) {
	var Bdd = req.query.db;
	if (Bdd==='iris') {
		var tablename = "IRIS_donnees_2021";
		var name = "NOM_IRIS";
	}
	if (Bdd==='dept')  {
		var tablename = "DEPARTEMENTS_donnees_2021";
		var name = "NOM_DEPT";

	}
	if (Bdd==='comm') {
		var tablename = "COMMUNES_donnees_2021";
		var name = "NOM_COM";
	}
	var what = req.query.what
	// if (what === "perchlm" && Bdd==='dept') {what = "%  HLM";}
	var type = req.query.type

	if (type=="Pastilles") {
//		var query = "select "+name+" as nam, cast(replace(\""+what+"\",',','.') as float) as varini,cast(replace(\""+what+"\",',','.') as float)/(select max(cast(replace(\""+what+"\",',','.') as float)) from "+tablename+") as var,AsGeoJSON(geom) as coo,(select max(cast(replace(\""+what+"\",',','.') as float)) from "+tablename+") as maxi from "+tablename+" where ST_EnvIntersects("+tablename+".geom,"+req.query.bb+");";
	var query = "select "+name+" as nam, cast(replace(\""+what+"\",',','.') as float) as varini,(cast(replace(\""+what+"\",',','.') as float) - (select min(cast(replace(\""+what+"\",',','.') as float)) from "+tablename+"))   / ((select max(cast(replace(\""+what+"\",',','.') as float)) from "+tablename+") - (select min(cast(replace(\""+what+"\",',','.') as float)) from "+tablename+")) as var,AsGeoJSON(geom) as coo,(select max(cast(replace(\""+what+"\",',','.') as float)) from "+tablename+") as maxi from "+tablename+" where ST_EnvIntersects("+tablename+".geom,"+req.query.bb+");";
	}
	else {
		var query = "select "+name+" as nam, cast(\""+what+"\" as text) as field, cast(\""+what+"\" as float) as var, cast(\""+what+"\" as float) as varini, AsGeoJSON(geom) as coo from "+tablename+" where ST_EnvIntersects("+tablename+".geom,"+req.query.bb+");";
	}
	var data = new Array();
	var RES;

	db.spatialite(function(err) {
	  db.each(query, function(err, row) {
		coord = JSON.parse(row.coo);
		row.coord = coord.coordinates;
		delete row.coo;
		delete row['geom'];
	   	data.push(row);
   		}, function() {

	  	RES = GeoJSON.parse(data, {'MultiPolygon': 'coord'});

		res.json(RES);
	  })
	});

	});

app.get('/export', function (req, res) {

	var DEPMT_COLUMNS = 'code_dept,nom_dept,code_chf,nom_chf,code_reg,nom_reg,SommeDePop as "Population en 2017",Pop014a as "Part des 0-14 ans en 2017",Pop1529 as "Part des 15-29 ans en 2017",Pop3044 as "Part des 30-44 ans en 2017",Pop4559 as "Part des 45-59 ans en 2017",Pop6074 as "Part des 60-74 ans en 2017",Pop75ans as "Part des 75 ans ou plus en 2017",PopHommes as "Part des Hommes en 2017",PopFemmes as "Part des Femmes en 2017",Pop15a_1 as "Part des 15 ans ou plus Agriculteurs exploitants en 2017",Pop15a_2 as "Part des 15 ans ou plus Artisans, commerçants, chefs d\'entreprise en 2017",Pop15a_3 as "Part des 15 ans ou plus Cadres, professions intellectuelles supérieures en 2017",Pop15a_4 as "Part des 15 ans ou plus Professions intermédiaires en 2017",Pop15a_5 as "Part des 15 ans ou plus Employés en 2017",Pop15a_6 as "Population 15 ans ou plus Ouvriers en 2017",Pop15a_7 as "Population Retraités en 2017",Pop15a_8 as "Part des 15 ans ou plus Autres en 2017",PopFranç as "Part de population française en 2017",PopEtrang as "Part de population étrangère en 2017",PopImmigr as "Part de population Immigrée en 2017",Menages as "Nombre de ménages en 2017",Taillemen as "Taille moyenne des ménages en 2017",MenagesH as "Part de ménages composés d\'hommes seuls en 2017",MenagesF as "Part de ménages composés de femmes seules en 2017",Menfamp as "Part de ménages composés de couples sans enfants",Menfam_1 as "Part de ménages composés de couples avec enfants",Menfam_2 as "Part de ménages composés de familles monoparentales",Aucundipl as "Part de population sans aucun diplôme ou au mieux BEPC, brevet des collèges",CAPBEP as "Part de personnes titulaires d\'un CAP ou BEP",Baccalaur as "Part de personnes titulaires d\'un baccalauréat",Diplômed as "Part de personnes titulaires d\'un diplôme d\'études supérieures",Actionsoc as "Nombre d\'équipements d\'action sociale pour personnes âgées",Actionsoc1 as "Nombre d\'équipements d\'action sociale pour enfants en bas-âge",Actions_2 as "Nombre d\'équipements d\'action sociale pour personnes handicapées",Autresser as "Nombre d\'équipements d\'autres services d\'action sociale",Grandessu as "Nombre de grandes surfaces",Commerces as "Nombre de commerces alimentaires",Commerce_1 as "Nombre de commerces spécialisés non alimentaires",Enseigneme as "Nombre d\'équipements d\'enseignement du premier degré",Enseigne_1 as "Nombre d\'équipements d\'enseignement du second degré",Enseigne_2 as "Nombre d\'équipements d\'enseignement supérieur",etablisse as "Nombre d\'établissements et services de santé",Fonctions as "Nombre de structures avec fonction médicale et paramédicale",Servicesp as "Nombre d\'équipements de Services publics",Servicesg as "Nombre d\'équipements de Services généraux",Servicesa as "Services automobiles",Artisanat as "Nombre d\'équipements en Artisanat du bâtiment",Autress_1 as "Nombre d\'équipements pour les autres services à  la population",equipemen as "Nombre d\'équipements sportifs",equipem_1 as "Nombre d\'équipements de loisirs",equipem_2 as "Nombre d\'équipements culturels et socioculturels",Infrastruc as "Nombre d\'infrastructures de transport",Tourisme as "Nombre d\'équipements de tourisme",Resprinc as "Part de résidences principales en 2017",Ressecon as "Part de résidences secondaires en 2017",Maisons as "Part de maisons en 2017",Appartemen as "Part d\'appartements en 2017",Resprinc_m as "Part de résidences principales de type Maison en 2017",Resprinc_a as "Part de résidences principales de type Appartement en 2017",Resprinc_1 as "Part de résidences principales de moins de 30 m2 en 2017",Resprinc_3 as "Part de résidences principales de 30 à moins de 40 m2 en 2017",Resprinc_4 as "Part de résidences principales de 40 à moins de 60 m2 en 2017",Resprinc_5 as "Part de résidences principales de 60 à  moins de 80 m2 en 2017",Resprinc_6 as "Part de résidences principales de 80 à moins de 100 m2 en 2017",Resprinc_7 as "Part de résidences principales de 100 à  moins de 120 m2 en 2017",Resprinc_8 as "Part de résidences principales de 120 m2 ou plus en 2017",sommedemen as "Part de ménages ayant emménagé il y a moins de 2 ans en 2017",Menages_2 as "Part de ménages ayant emménagé entre 2 et 4 ans 2017",Menages_3 as "Part de ménages ayant emménagé entre 5 et 9 ans en 2017",Menages_4 as "Part de ménages ayant emménagé il y a 10 ans ou plus en 2017",Menagesa as "Part de ménages possédant au moins une voiture en 2017","NB HLM" as "Nombre de logements appartenant à un organisme HLM","perchlm" as "Part de logements appartenant à un organisme HLM"';

	// ,men_imp as "Part des ménages fiscaux imposés",bas_rev as "Taux de bas revenus déclarés au seuil de 60 %",tx_pauv as "Taux de pauvreté au seuil de 60 %"

	var COMM_COLUMNS = 'insee_com,superficie,nom_com,SommeDePop as "Population en 2017",Pop014a as "Part des 0-14 ans en 2017",Pop1529 as "Part des 15-29 ans en 2017",Pop3044 as "Part des 30-44 ans en 2017",Pop4559 as "Part des 45-59 ans en 2017",Pop6074 as "Part des 60-74 ans en 2017",Pop75ans as "Part des 75 ans ou plus en 2017",PopHommes as "Part des Hommes en 2017",PopFemmes as "Part des Femmes en 2017",Pop15a_1 as "Part des 15 ans ou plus Agriculteurs exploitants en 2017",Pop15a_2 as "Part des 15 ans ou plus Artisans, commerçants, chefs d\'entreprise en 2017",Pop15a_3 as "Part des 15 ans ou plus Cadres, professions intellectuelles supérieures en 2017",Pop15a_4 as "Part des 15 ans ou plus Professions intermédiaires en 2017",Pop15a_5 as "Part des 15 ans ou plus Employés en 2017",Pop15a_6 as "Population 15 ans ou plus Ouvriers en 2017",Pop15a_7 as "Population Retraités en 2017",Pop15a_8 as "Part des 15 ans ou plus Autres en 2017",PopFranç as "Part de population française en 2017",PopEtrang as "Part de population étrangère en 2017",PopImmigr as "Part de population Immigrée en 2017",Menages as "Nombre de ménages en 2017",Taillemen as "Taille moyenne des ménages en 2017",MenagesH as "Part de ménages composés d\'hommes seuls en 2017",MenagesF as "Part de ménages composés de femmes seules en 2017",Menfamp as "Part de ménages composés de couples sans enfants",Menfam_1 as "Part de ménages composés de couples avec enfants",Menfam_2 as "Part de ménages composés de familles monoparentales",Aucundipl as "Part de population sans aucun diplôme ou au mieux BEPC, brevet des collèges",CAPBEP as "Part de personnes titulaires d\'un CAP ou BEP",Baccalaur as "Part de personnes titulaires d\'un baccalauréat",Diplômed as "Part de personnes titulaires d\'un diplôme d\'études supérieures",Actionsoc as "Nombre d\'équipements d\'action sociale pour personnes âgées",Actionsoc1 as "Nombre d\'équipements d\'action sociale pour enfants en bas-âge",Actions_2 as "Nombre d\'équipements d\'action sociale pour personnes handicapées",Autresser as "Nombre d\'équipements d\'autres services d\'action sociale",Grandessu as "Nombre de grandes surfaces",Commerces as "Nombre de commerces alimentaires",Commerce_1 as "Nombre de commerces spécialisés non alimentaires",Enseigneme as "Nombre d\'équipements d\'enseignement du premier degré",Enseigne_1 as "Nombre d\'équipements d\'enseignement du second degré",Enseigne_2 as "Nombre d\'équipements d\'enseignement supérieur",etablisse as "Nombre d\'établissements et services de santé",Fonctions as "Nombre de structures avec fonction médicale et paramédicale",Servicesp as "Nombre d\'équipements de Services publics",Servicesg as "Nombre d\'équipements de Services généraux",Servicesa as "Services automobiles",Artisanat as "Nombre d\'équipements en Artisanat du bâtiment",Autress_1 as "Nombre d\'équipements pour les autres services à  la population",equipemen as "Nombre d\'équipements sportifs",equipem_1 as "Nombre d\'équipements de loisirs",equipem_2 as "Nombre d\'équipements culturels et socioculturels",Infrastruc as "Nombre d\'infrastructures de transport",Tourisme as "Nombre d\'équipements de tourisme",etude_Dans as "Part des personnes ayant fait leurs études dans la commune de résidence actuelle",etude_Da_1 as "Part des personnes ayant fait leurs études dans une autre commune du département de résidence",etude_Da_2 as "Part des personnes ayant fait leurs études dans un autre département de la région de résidence",etude_Hors as "Part des personnes ayant fait leurs études hors de la région de résidence actuelle, en Métropole",etude_Ho_1 as "Part des personnes ayant fait leurs études hors de la région de résidence actuelle, dans un DOM",etude_Ho_2 as "Part des personnes ayant fait leurs études hors de la région de résidence actuelle, dans une COM",etude_Alet as "Part des personnes ayant fait leurs études à  l\'étranger",etude_Sans as "Sans objet (pas d\'inscription dans un établissement d\'enseignement)",etude_Ho_3 as "Part des personnes ayant fait leurs études hors de la résidence principale",naissance_ as "Part des personnes nées dans le département de résidence actuelle",Naissance_1 as "Part des personnes nées dans un autre département de la région de résidence actuelle",Naissance_2 as "Part des personnes nées hors de la région de résidence actuelle : en métropole",Naissance_3 as "Part des personnes nées hors de la région de résidence actuelle : dans un DOM",Naissance_4 as "Part des personnes nées hors de la région de résidence actuelle : dans une COM",Naissance_5 as "Part des personnes nées à  l\'étranger",Naissance_6 as "Part des personnes nées hors résidence principale",travail_Da as "Part des personnes travaillant dans la commune de résidence actuelle",travail__1 as "Part des personnes travaillant dans une autre commune du département de résidence",travail__2 as "Part des personnes travaillant dans un autre département de la région de résidence",travail_Ho as "Part des personnes travaillant hors de la région de résidence actuelle : en métropole",Travail__3 as "Part des personnes travaillant hors de la région de résidence actuelle : dans un DOM",Travail__4 as "Part des personnes travaillant hors de la région de résidence actuelle : dans une COM",travail_Al as "Part des personnes travaillant à l\'étranger",travail_Sa as "Sans objet (sans emploi)",Travail__5 as "Part des personnes travaillant hors résidence principale",Resprinc as "Part de résidences principales en 2017",Ressecon as "Part de résidences secondaires en 2017",Maisons as "Part de maisons en 2017",Appartemen as "Part d\'appartements en 2017",Resprinc_m as "Part de résidences principales de type Maison en 2017",Resprinc_a as "Part de résidences principales de type Appartement en 2017",Resprinc_1 as "Part de résidences principales de moins de 30 m2 en 2017",Resprinc_3 as "Part de résidences principales de 30 à moins de 40 m2 en 2017",Resprinc_4 as "Part de résidences principales de 40 à moins de 60 m2 en 2017",Resprinc_5 as "Part de résidences principales de 60 à  moins de 80 m2 en 2017",Resprinc_6 as "Part de résidences principales de 80 à moins de 100 m2 en 2017",Resprinc_7 as "Part de résidences principales de 100 à  moins de 120 m2 en 2017",Resprinc_8 as "Part de résidences principales de 120 m2 ou plus en 2017",sommedemen as "Part de ménages ayant emménagé il y a moins de 2 ans en 2017",Menages_2 as "Part de ménages ayant emménagé entre 2 et 4 ans 2017",Menages_3 as "Part de ménages ayant emménagé entre 5 et 9 ans en 2017",Menages_4 as "Part de ménages ayant emménagé il y a 10 ans ou plus en 2017",Menagesa as "Part de ménages possédant au moins une voiture en 2017","NB HLM" as "Nombre de logements appartenant à un organisme HLM",perchlm as "Part de logements appartenant à un organisme HLM",men_imp as "Part des ménages fiscaux imposés",bas_rev as "Taux de bas revenus déclarés au seuil de 60 %",tx_pauv as "Taux de pauvreté au seuil de 60 %"';

	var IRIS_COLUMNS = 'insee_com,nom_com,iris,code_iris,nom_iris,typ_iris,SommeDePop as "Population en 2017",Pop014a as "Part des 0-14 ans en 2017",Pop1529 as "Part des 15-29 ans en 2017",Pop3044 as "Part des 30-44 ans en 2017",Pop4559 as "Part des 45-59 ans en 2017",Pop6074 as "Part des 60-74 ans en 2017",Pop75ans as "Part des 75 ans ou plus en 2017",PopHommes as "Part des Hommes en 2017",PopFemmes as "Part des Femmes en 2017",Pop15a_1 as "Part des 15 ans ou plus Agriculteurs exploitants en 2017",Pop15a_2 as "Part des 15 ans ou plus Artisans, commerçants, chefs d\'entreprise en 2017",Pop15a_3 as "Part des 15 ans ou plus Cadres, professions intellectuelles supérieures en 2017",Pop15a_4 as "Part des 15 ans ou plus Professions intermédiaires en 2017",Pop15a_5 as "Part des 15 ans ou plus Employés en 2017",Pop15a_6 as "Population 15 ans ou plus Ouvriers en 2017",Pop15a_7 as "Population Retraités en 2017",Pop15a_8 as "Part des 15 ans ou plus Autres en 2017",PopFranç as "Part de population française en 2017",PopEtrang as "Part de population étrangère en 2017",PopImmigr as "Part de population Immigrée en 2017",Menages as "Nombre de ménages en 2017",Taillemen as "Taille moyenne des ménages en 2017",MenagesH as "Part de ménages composés d\'hommes seuls en 2017",MenagesF as "Part de ménages composés de femmes seules en 2017",Menfamp as "Part de ménages composés de couples sans enfants",Menfam_1 as "Part de ménages composés de couples avec enfants",Menfam_2 as "Part de ménages composés de familles monoparentales",Aucundipl as "Part de population sans aucun diplôme ou au mieux BEPC, brevet des collèges",CAPBEP as "Part de personnes titulaires d\'un CAP ou BEP",Baccalaur as "Part de personnes titulaires d\'un baccalauréat",Diplômed as "Part de personnes titulaires d\'un diplôme d\'études supérieures",Actionsoc as "Nombre d\'équipements d\'action sociale pour personnes âgées",Actionsoc1 as "Nombre d\'équipements d\'action sociale pour enfants en bas-âge",Actions_2 as "Nombre d\'équipements d\'action sociale pour personnes handicapées",Autresser as "Nombre d\'équipements d\'autres services d\'action sociale",Grandessu as "Nombre de grandes surfaces",Commerces as "Nombre de commerces alimentaires",Commerce_1 as "Nombre de commerces spécialisés non alimentaires",Enseigneme as "Nombre d\'équipements d\'enseignement du premier degré",Enseigne_1 as "Nombre d\'équipements d\'enseignement du second degré",Enseigne_2 as "Nombre d\'équipements d\'enseignement supérieur",etablisse as "Nombre d\'établissements et services de santé",Fonctions as "Nombre de structures avec fonction médicale et paramédicale",Servicesp as "Nombre d\'équipements de Services publics",Servicesg as "Nombre d\'équipements de Services généraux",Servicesa as "Services automobiles",Artisanat as "Nombre d\'équipements en Artisanat du bâtiment",Autress_1 as "Nombre d\'équipements pour les autres services à  la population",equipemen as "Nombre d\'équipements sportifs",equipem_1 as "Nombre d\'équipements de loisirs",equipem_2 as "Nombre d\'équipements culturels et socioculturels",Infrastruc as "Nombre d\'infrastructures de transport",Tourisme as "Nombre d\'équipements de tourisme",etude_Dans as "Part des personnes ayant fait leurs études dans la commune de résidence actuelle",etude_Da_1 as "Part des personnes ayant fait leurs études dans une autre commune du département de résidence",etude_Da_2 as "Part des personnes ayant fait leurs études dans un autre département de la région de résidence",etude_Hors as "Part des personnes ayant fait leurs études hors de la région de résidence actuelle, en Métropole",etude_Ho_1 as "Part des personnes ayant fait leurs études hors de la région de résidence actuelle, dans un DOM",etude_Ho_2 as "Part des personnes ayant fait leurs études hors de la région de résidence actuelle, dans une COM",etude_Alet as "Part des personnes ayant fait leurs études à  l\'étranger",etude_Sans as "Sans objet (pas d\'inscription dans un établissement d\'enseignement)",etude_Ho_3 as "Part des personnes ayant fait leurs études hors de la résidence principale",naissance_ as "Part des personnes nées dans le département de résidence actuelle",Naissance_1 as "Part des personnes nées dans un autre département de la région de résidence actuelle",Naissance_2 as "Part des personnes nées hors de la région de résidence actuelle : en métropole",Naissance_3 as "Part des personnes nées hors de la région de résidence actuelle : dans un DOM",Naissance_4 as "Part des personnes nées hors de la région de résidence actuelle : dans une COM",Naissance_5 as "Part des personnes nées à  l\'étranger",Naissance_6 as "Part des personnes nées hors résidence principale",travail_Da as "Part des personnes travaillant dans la commune de résidence actuelle",travail__1 as "Part des personnes travaillant dans une autre commune du département de résidence",travail__2 as "Part des personnes travaillant dans un autre département de la région de résidence",travail_Ho as "Part des personnes travaillant hors de la région de résidence actuelle : en métropole",Travail__3 as "Part des personnes travaillant hors de la région de résidence actuelle : dans un DOM",Travail__4 as "Part des personnes travaillant hors de la région de résidence actuelle : dans une COM",travail_Al as "Part des personnes travaillant à l\'étranger",travail_Sa as "Sans objet (sans emploi)",Travail__5 as "Part des personnes travaillant hors résidence principale",Resprinc as "Part de résidences principales en 2017",Ressecon as "Part de résidences secondaires en 2017",Maisons as "Part de maisons en 2017",Appartemen as "Part d\'appartements en 2017",Resprinc_m as "Part de résidences principales de type Maison en 2017",Resprinc_a as "Part de résidences principales de type Appartement en 2017",Resprinc_1 as "Part de résidences principales de moins de 30 m2 en 2017",Resprinc_3 as "Part de résidences principales de 30 à moins de 40 m2 en 2017",Resprinc_4 as "Part de résidences principales de 40 à moins de 60 m2 en 2017",Resprinc_5 as "Part de résidences principales de 60 à  moins de 80 m2 en 2017",Resprinc_6 as "Part de résidences principales de 80 à moins de 100 m2 en 2017",Resprinc_7 as "Part de résidences principales de 100 à  moins de 120 m2 en 2017",Resprinc_8 as "Part de résidences principales de 120 m2 ou plus en 2017",sommedemen as "Part de ménages ayant emménagé il y a moins de 2 ans en 2017",Menages_2 as "Part de ménages ayant emménagé entre 2 et 4 ans 2017",Menages_3 as "Part de ménages ayant emménagé entre 5 et 9 ans en 2017",Menages_4 as "Part de ménages ayant emménagé il y a 10 ans ou plus en 2017",Menagesa as "Part de ménages possédant au moins une voiture en 2017","NB HLM" as "Nombre de logements appartenant à un organisme HLM","%  hlm" as "Part de logements appartenant à un organisme HLM",men_imp as "Part des ménages fiscaux imposés",bas_rev as "Taux de bas revenus déclarés au seuil de 60 %",tx_pauv as "Taux de pauvreté au seuil de 60 %"';

	var conf = {
		departement: {
			table: 'DEPARTEMENTS_donnees_2021',
			columns: DEPMT_COLUMNS,
			nameColumn: 'nom_dept'
		},
		commune: {
			table: 'COMMUNES_donnees_2021',
			columns: COMM_COLUMNS,
			nameColumn: 'nom_com'
		},
		iris: {
			table: 'IRIS_donnees_2021',
			columns: IRIS_COLUMNS,
			nameColumn: 'nom_iris'
		}
	};

	var conf = req.query.bdd == 'dept' ? conf.departement
		: req.query.bdd == 'comm' ? conf.commune
		: req.query.bdd == 'iris' ? conf.iris
		: null;

	var query = 'select ' + conf.columns
		+ ' from ' + conf.table
		+ ' where ' + conf.nameColumn + ' = "' + req.query.area + '";';

	db.spatialite(function(err) {
	 	db.each(query, function(err, row) {
	 		res.json(row);
	 	})
	});

});

app.listen(process.env.CECIM_PORT || 3000);
